package com.ElyStudio.leGaou.activities;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.MenuItem;

import com.google.android.material.navigation.NavigationBarView;
import com.google.firebase.messaging.FirebaseMessaging;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.databinding.ActivityMainBinding;
import com.ElyStudio.leGaou.fragment.AccountFragment;
import com.ElyStudio.leGaou.fragment.GamesFragment;
import com.ElyStudio.leGaou.fragment.HomeFragment;
import com.ElyStudio.leGaou.fragment.LeaderboardFragment;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.Constants;

public class MainActivity extends AppCompat {

    ActivityMainBinding binding;
    SharedPreferences sharedPreferences;
    boolean isNotificationEnabled,appMode;
    String selectedAppLanguage;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityMainBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        sharedPreferences = getSharedPreferences(Constants.appPrefs,MODE_PRIVATE);
        isNotificationEnabled = sharedPreferences.getBoolean(Constants.notificationsEnabled,false);
        appMode = sharedPreferences.getBoolean(Constants.appColorMode,false);
        if(isNotificationEnabled)
        {
            FirebaseMessaging.getInstance().subscribeToTopic(Constants.NOTIFICATION_TOPIC);
        }
        else
        {
            FirebaseMessaging.getInstance().unsubscribeFromTopic(Constants.NOTIFICATION_TOPIC);
        }

        getSupportFragmentManager().beginTransaction().replace(R.id.fragmentContainer,new HomeFragment()).commit();

        binding.bottomNavigationBar.setOnItemSelectedListener(new NavigationBarView.OnItemSelectedListener() {
            @Override
            public boolean onNavigationItemSelected(@NonNull MenuItem item) {

                Fragment currentFragment = null;

                switch (item.getItemId())
                {
                    case R.id.home_menu:
                        currentFragment = new HomeFragment();
                        break;

                    case  R.id.game_menu:
                        currentFragment = new GamesFragment();
                        break;

                    case  R.id.leaderboard_menu:
                        currentFragment = new LeaderboardFragment();
                        break;

                    case R.id.account:
                        currentFragment = new AccountFragment();
                        break;
                }
                getSupportFragmentManager().beginTransaction().replace(R.id.fragmentContainer,currentFragment).commit();
                return true;
            }
        });



    }
}